

<?php $__env->startSection('title', 'All Appointments'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">All Appointments</h1>
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
            <i class="fas fa-arrow-left"></i> <span class="hidden sm:inline">Back to Dashboard</span><span class="sm:hidden">Back</span>
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Doctor</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden lg:table-cell">Branch</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date/Time</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <div>
                            <div class="font-medium text-sm sm:text-base"><?php echo e($appointment->patient->full_name); ?></div>
                            <div class="text-xs sm:text-sm text-gray-500"><?php echo e($appointment->patient->patient_id); ?></div>
                        </div>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden md:table-cell">
                        <span class="text-sm"><?php echo e($appointment->doctor ? $appointment->doctor->full_name : 'Not Assigned'); ?></span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden lg:table-cell">
                        <span class="text-sm"><?php echo e($appointment->branch->name); ?></span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <?php if($appointment->appointment_date): ?>
                            <span class="text-xs sm:text-sm"><?php echo e($appointment->appointment_date->format('M d, Y H:i')); ?></span>
                        <?php else: ?>
                            <span class="text-gray-400 text-xs sm:text-sm">Immediate</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <span class="bg-purple-100 text-purple-800 px-2 py-1 rounded text-xs">
                            <?php echo e(ucfirst($appointment->appointment_type)); ?>

                        </span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <span class="px-2 py-1 text-xs rounded-full 
                            <?php if($appointment->status === 'completed'): ?> bg-green-100 text-green-800
                            <?php elseif($appointment->status === 'pending'): ?> bg-yellow-100 text-yellow-800
                            <?php elseif($appointment->status === 'in_progress'): ?> bg-blue-100 text-blue-800
                            <?php elseif($appointment->status === 'cancelled'): ?> bg-red-100 text-red-800
                            <?php else: ?> bg-gray-100 text-gray-800
                            <?php endif; ?>">
                            <?php echo e(ucfirst($appointment->status)); ?>

                        </span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap text-xs sm:text-sm font-medium">
                        <div class="flex flex-col gap-1">
                            <?php if($appointment->prescription): ?>
                                <a href="<?php echo e(route('prescriptions.show', $appointment->prescription->id)); ?>" class="text-blue-600 hover:text-blue-900">
                                    <i class="fas fa-prescription"></i> <span class="hidden sm:inline">View Prescription</span><span class="sm:hidden">Prescription</span>
                                </a>
                            <?php endif; ?>
                            <?php if($appointment->google_meet_link): ?>
                                <a href="<?php echo e($appointment->google_meet_link); ?>" class="text-green-600 hover:text-green-900" target="_blank">
                                    <i class="fas fa-video"></i> <span class="hidden sm:inline">Google Meet</span><span class="sm:hidden">Meet</span>
                                </a>
                            <?php elseif($appointment->video_call_room_id): ?>
                                <a href="<?php echo e($appointment->appointment_type === 'immediate' ? route('pharmacist.video-call', $appointment->id) : '#'); ?>" class="text-blue-600 hover:text-blue-900">
                                    <i class="fas fa-video"></i> <span class="hidden sm:inline">Video Call</span><span class="sm:hidden">Call</span>
                                </a>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="px-6 py-4 text-center text-gray-500">
                        No appointments found.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        </div>
    </div>

    <?php if($appointments->count() > 0): ?>
    <div class="mt-4 text-sm text-gray-600">
        Showing <?php echo e($appointments->count()); ?> appointment(s)
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/admin/appointments.blade.php ENDPATH**/ ?>